# WordPress Multi-Site Manager - Инструкции

Система за лесно създаване и управление на множество WordPress сайтове с Docker.

---

## 🚀 Първоначална инсталация

```bash
# 1. Създай файла
nano wp-manager.sh

# 2. Копирай скрипта вътре

# 3. Направи го изпълним
chmod +x wp-manager.sh

# 4. Добави Docker права (само първи път)
sudo usermod -aG docker $USER
newgrp docker
```

---

## 📋 Основни команди

### Създаване на нов сайт
```bash
./wp-manager.sh create mysite
```
- Автоматично генерира пароли
- Намира свободен порт
- Стартира MySQL + WordPress
- Готово за ползване след 30-60 секунди

### Списък с всички сайтове
```bash
./wp-manager.sh list
```
- Показва активни (●) и спрени (○) сайтове
- Показва портовете на всеки сайт

### Информация за сайт (ВАЖНО!)
```bash
./wp-manager.sh info mysite
```
**ТУК СА ВСИЧКИ ПАРОЛИ И ДАННИ:**
- URL на сайта
- Admin потребител и парола
- MySQL креденшъли
- Локация на файловете

### Спиране на сайт
```bash
./wp-manager.sh stop mysite
```
Спира контейнерите, но запазва данните

### Стартиране на сайт
```bash
./wp-manager.sh start mysite
```
Стартира спрян сайт

### Изтриване на сайт
```bash
./wp-manager.sh delete mysite
```
**ВНИМАНИЕ:** Изтрива всичко - файлове, база данни, всичко!
Ще поиска потвърждение (трябва да напишеш `yes`)

### Помощ
```bash
./wp-manager.sh help
```

---

## 🌐 Как да отворя сайта

### Локално (на същата машина):
```bash
http://localhost:8080
```

### От друг компютър в мрежата:
```bash
http://10.20.20.79:8080
```
*(Замени с твоя IP и порт)*

### WordPress Admin:
```bash
http://10.20.20.79:8080/wp-admin
```

**Портът зависи от сайта! Виж го с:**
```bash
./wp-manager.sh list    # или
./wp-manager.sh info mysite
```

---

## 🔥 Отваряне на портове във firewall

Ако не можеш да достъпиш сайта отвън:

```bash
# За UFW (Ubuntu/Debian)
sudo ufw allow 8080/tcp
sudo ufw allow 8081/tcp
sudo ufw allow 8082/tcp

# За Firewalld (CentOS/RHEL)
sudo firewall-cmd --add-port=8080-8090/tcp --permanent
sudo firewall-cmd --reload

# Провери статуса
sudo ufw status
# или
sudo firewall-cmd --list-ports
```

---

## 📁 Структура на файловете

```
.
├── wp-manager.sh          # Главният скрипт
├── README.md              # Този файл
└── sites/                 # Всички сайтове са тук
    ├── mysite/
    │   ├── docker-compose.yml
    │   ├── .env           # ПАРОЛИ И НАСТРОЙКИ
    │   ├── php.ini        # PHP конфигурация
    │   ├── wordpress/     # WordPress файлове
    │   └── mysql/         # MySQL база данни
    ├── site2/
    └── site3/
```

---

## 🔧 Работа с файловете на сайта

### WordPress файлове:
```bash
cd sites/mysite/wordpress
```
Тук са всички WordPress файлове (themes, plugins, uploads)

### Backup на сайт:
```bash
# Архивирай целия сайт
tar -czf mysite-backup.tar.gz sites/mysite/

# Възстанови
tar -xzf mysite-backup.tar.gz
./wp-manager.sh start mysite
```

### Преглед на логове:
```bash
cd sites/mysite
docker-compose logs -f wordpress   # WordPress логове
docker-compose logs -f db          # MySQL логове
```

---

## 💡 Примерни сценарии

### Създаване на 3 тестови сайта наведнъж:
```bash
./wp-manager.sh create test1
./wp-manager.sh create test2
./wp-manager.sh create test3
./wp-manager.sh list
```

### Временно спиране на сайт:
```bash
./wp-manager.sh stop test2
# ... работиш по друго ...
./wp-manager.sh start test2
```

### Виждане на всички пароли за сайт:
```bash
./wp-manager.sh info test1
# или директно
cat sites/test1/.env
```

### Production deployment:
```bash
# Създай сайта
./wp-manager.sh create production

# Вземи данните
./wp-manager.sh info production

# Отвори порта
sudo ufw allow 8080/tcp

# Готово! http://your-server-ip:8080
```

---

## ⚙️ PHP настройки

Всеки сайт има `php.ini` с оптимизирани настройки:

- **Upload limit:** 256MB
- **Memory limit:** 512MB
- **Execution time:** 300 секунди
- **Max vars:** 3000

Можеш да ги промениш в `sites/mysite/php.ini` и рестартираш:
```bash
./wp-manager.sh stop mysite
./wp-manager.sh start mysite
```

---

## 🔒 Сигурност

- **Паролите** се генерират автоматично и са 25 символа
- **MySQL** не е достъпна отвън (само за WordPress)
- **Всеки сайт** е изолиран в собствена Docker мрежа
- **.env файловете** съдържат чувствителни данни - не ги качвай в Git!

### За production:
```bash
# Променете admin паролата след първо влизане!
# Инсталирайте SSL сертификат
# Добавете .htaccess за сигурност
```

---

## 🐛 Проблеми и решения

### Сайтът не се отваря след създаване
```bash
# Изчакай 60 секунди за MySQL инициализация
# Провери дали контейнерите работят:
cd sites/mysite
docker-compose ps
```

### Порт е зает
```bash
# Скриптът автоматично намира свободен порт
# Ако има проблем, спри стария сайт:
./wp-manager.sh stop oldsite
```

### Permission denied
```bash
sudo chown -R $USER:$USER sites/
```

### Docker not running
```bash
sudo systemctl start docker
sudo systemctl enable docker
```

### База данни не се свързва
```bash
cd sites/mysite
docker-compose down
docker-compose up -d
# Изчакай 30 секунди
```

---

## 📊 Ресурси

- **Документация:** [WordPress Docker](https://hub.docker.com/_/wordpress)
- **Docker Compose:** [docs.docker.com](https://docs.docker.com/compose/)
- **PHP настройки:** [php.net](https://www.php.net/manual/en/ini.core.php)

---

## 🎯 Бързи команди (за копиране)

```bash
# Нов сайт
./wp-manager.sh create mysite

# Виж пароли
./wp-manager.sh info mysite

# Списък
./wp-manager.sh list

# Отвори порт
sudo ufw allow 8080/tcp

# Логове
cd sites/mysite && docker-compose logs -f

# Backup
tar -czf backup.tar.gz sites/mysite/
```

---

## 📝 Бележки

- Всеки сайт използва около **500MB-1GB** RAM
- MySQL данните са в `sites/mysite/mysql/`
- WordPress файловете са в `sites/mysite/wordpress/`
- Сайтовете са **production-ready** - можеш да ги използваш направо
- Не е нужен Nginx/Apache - Docker се грижи за всичко

---

**Направено с ❤️ за лесна WordPress разработка**

*Последна актуализация: 2026-01-14*