#!/bin/bash

# shell скрипт за изпълнение на командите и създаване на файлове

# Създаване на директории
mkdir -p {wp1,wp2,wp3,wp4,php-inis,envs,mysql-init}

# Генериране на init.sql
cat > mysql-init/init.sql <<'SQL'
CREATE DATABASE IF NOT EXISTS wordpress1;
CREATE DATABASE IF NOT EXISTS wordpress2;
CREATE DATABASE IF NOT EXISTS wordpress3;
CREATE DATABASE IF NOT EXISTS wordpress4;

CREATE USER IF NOT EXISTS 'wpuser'@'%' IDENTIFIED BY 'wppassword';
GRANT ALL PRIVILEGES ON wordpress1.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress2.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress3.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress4.* TO 'wpuser'@'%';
FLUSH PRIVILEGES;
SQL

# Генериране на docker-compose.yml
cat > docker-compose.yml <<'YAML'
version: '3.8'

services:
  db:
    image: mysql:5.7
    volumes:
      - db_data:/var/lib/mysql
      - ./mysql-init:/docker-entrypoint-initdb.d
    environment:
      MYSQL_ROOT_PASSWORD: rootpassword
      MYSQL_USER: wpuser
      MYSQL_PASSWORD: wppassword
    networks:
      wp_network:

  wordpress1:
    image: wordpress:php8.1-apache
    ports: ["8090:80"]
    volumes:
      - ./wp1:/var/www/html
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: wpuser
      WORDPRESS_DB_PASSWORD: wppassword
      WORDPRESS_DB_NAME: wordpress1
    networks:
      wp_network:
    depends_on:
      - db

networks:
  wp_network:

volumes:
  db_data:
YAML

echo "Конфигурацията е готова! Стартирайте с: docker-compose up -d"