#!/bin/bash

# Създаване на директории
mkdir -p {wp1,wp2,wp3,wp4,php-inis,envs,mysql-init}

# SQL за инициализация на базите
cat > mysql-init/init.sql <<EOF
CREATE DATABASE IF NOT EXISTS wordpress1;
CREATE DATABASE IF NOT EXISTS wordpress2;
CREATE DATABASE IF NOT EXISTS wordpress3;
CREATE DATABASE IF NOT EXISTS wordpress4;

CREATE USER IF NOT EXISTS 'wpuser'@'%' IDENTIFIED BY 'wppassword';
GRANT ALL PRIVILEGES ON wordpress1.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress2.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress3.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress4.* TO 'wpuser'@'%';
FLUSH PRIVILEGES;
EOF

# php.ini файлове
for i in {1..4}; do
  cat > "php-inis/php${i}.ini" <<EOF
upload_max_filesize = 64M
post_max_size = 64M
memory_limit = 256M
max_execution_time = 300
EOF
done

# .env файлове
for i in {1..4}; do
  cat > "envs/wp${i}.env" <<EOF
WP_DEBUG=false
WP_DEBUG_LOG=false
WP_DEBUG_DISPLAY=false
WP_HOME=http://your-server-ip:809$((i-1))
WP_SITEURL=http://your-server-ip:809$((i-1))
EOF
done

# docker-compose.yml
cat > docker-compose.yml <<EOF
version: '3.8'

services:
  db:
    image: mysql:5.7
    container_name: wp_mysql
    networks:
      wp_network:
        ipv4_address: 10.110.112.5
    volumes:
      - db_data:/var/lib/mysql
      - ./mysql-init:/docker-entrypoint-initdb.d
    environment:
      MYSQL_ROOT_PASSWORD: rootpassword
      MYSQL_USER: wpuser
      MYSQL_PASSWORD: wppassword
    restart: unless-stopped

$(for i in {1..4}; do
  port=$((8090 + i - 1))
  ip=$((10 + i - 1))
  cat <<WPEOF
  wordpress${i}:
    image: wordpress:php7.4-apache
    container_name: wp_site${i}
    networks:
      wp_network:
        ipv4_address: 10.110.112.${ip}
    ports:
      - "${port}:80"
    volumes:
      - ./wp${i}:/var/www/html
      - ./php-inis/php${i}.ini:/usr/local/etc/php/conf.d/custom-php.ini
      - ./envs/wp${i}.env:/var/www/html/.env
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: wpuser
      WORDPRESS_DB_PASSWORD: wppassword
      WORDPRESS_DB_NAME: wordpress${i}
    depends_on:
      - db
    restart: unless-stopped

WPEOF
done)

networks:
  wp_network:
    driver: bridge
    ipam:
      config:
        - subnet: 10.110.112.0/24

volumes:
  db_data:
EOF

echo "Скриптът завърши успешно!"
echo "Стартирайте с: docker-compose up -d"