#!/bin/bash

# Създаване на директории
mkdir -p {wp1,wp2,wp3,wp4,php-inis,envs,mysql-init}

# SQL за инициализация на базите
cat > mysql-init/init.sql <<EOF
CREATE DATABASE IF NOT EXISTS wordpress1;
CREATE DATABASE IF NOT EXISTS wordpress2;
CREATE DATABASE IF NOT EXISTS wordpress3;
CREATE DATABASE IF NOT EXISTS wordpress4;

CREATE USER IF NOT EXISTS 'wpuser'@'%' IDENTIFIED BY 'wppassword';
GRANT ALL PRIVILEGES ON wordpress1.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress2.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress3.* TO 'wpuser'@'%';
GRANT ALL PRIVILEGES ON wordpress4.* TO 'wpuser'@'%';
FLUSH PRIVILEGES;
EOF

# php.ini файлове с актуални настройки
for i in {1..4}; do
  cat > "php-inis/php${i}.ini" <<EOF
memory_limit = 256M
upload_max_filesize = 64M
post_max_size = 64M
max_execution_time = 300
opcache.enable=1
opcache.memory_consumption=128
opcache.max_accelerated_files=4000
EOF
done

# Правилна конфигурация за WordPress (wp-config.php)
for i in {1..4}; do
  cat > "envs/wp${i}.env" <<EOF
# Environment variables for WordPress ${i}
DB_NAME=wordpress${i}
DB_USER=wpuser
DB_PASSWORD=wppassword
DB_HOST=db

WP_DEBUG=false
WP_ENVIRONMENT_TYPE=production
EOF

  # Генериране на wp-config.php с поддръжка на .env
  cat > "wp${i}/wp-config.php" <<'WPCONFIG'
<?php
// Load .env file if exists
if (file_exists(__DIR__.'/.env')) {
    $env = parse_ini_file(__DIR__.'/.env');
    foreach ($env as $key => $value) {
        putenv("$key=$value");
    }
}

// Database settings
define('DB_NAME', getenv('DB_NAME'));
define('DB_USER', getenv('DB_USER'));
define('DB_PASSWORD', getenv('DB_PASSWORD'));
define('DB_HOST', getenv('DB_HOST'));

// Security keys
define('AUTH_KEY',         ',V~U;_JxY)0?e}@)/r+!i)L-2x][&9GD!)0-e6f+=^R9wIAO%1HGA`Sf@fbC{{d-');
define('SECURE_AUTH_KEY',  'zoNHd%qu+H2FkWeRQXvZ[M<Ipsd2qHG/KnTy]S]MumWjxN_^M_r{p:mqYG+ZJL9>');
define('LOGGED_IN_KEY',    'yx+HS[<(j+|Hg{(e3j~}GB>8m2%qu:W;V*+@&w|-;-~FA7+#T4rLfoC.:#}OJ+:o');
define('NONCE_KEY',        ':J$p)Q4@+-,t5WTyP|Wxx|:J-5ZJXx84{$!JxgM|4U]fTkvia-9:LHTaGRRa/VX;');
define('AUTH_SALT',        '}M>0+l?TUo#r[AUV^! *#@n8]tP1+UiB4uTf bNJ/ife~jP%-ixn; UY<FmRp%O:');
define('SECURE_AUTH_SALT', 'b-j!{nf96#AL.[^2K<F~A49/h^r.M&^|&?U/^G6_sBMk4n5^::/Ed,jo4fn mdPU');
define('LOGGED_IN_SALT',   '~h;zO| hO.GL$DJ<ZkAK?rm{+Y:-A@LY|_,hmI6)yHBl(q|WW:+cwL+Sn:|+{$sl');
define('NONCE_SALT',       '|YkAjobA~YA6h$6;gspFz<)]-J!@ODo9^Y+2|4Q|.b,5.nGr;ghc#X>P+R=2cS:%');

// WordPress settings
define('WP_DEBUG', filter_var(getenv('WP_DEBUG'), FILTER_VALIDATE_BOOLEAN));
define('WP_ENVIRONMENT_TYPE', getenv('WP_ENVIRONMENT_TYPE') ?: 'production');

\$table_prefix = 'wp_';

// Absolute path to the WordPress directory
if (!defined('ABSPATH')) {
    define('ABSPATH', __DIR__ . '/');
}

require_once ABSPATH . 'wp-settings.php';
WPCONFIG
done

# docker-compose.yml с актуален PHP 8.1
cat > docker-compose.yml <<EOF
version: '3.8'

services:
  db:
    image: mysql:5.7
    container_name: wp_mysql
    networks:
      wp_network:
        ipv4_address: 10.110.112.5
    volumes:
      - db_data:/var/lib/mysql
      - ./mysql-init:/docker-entrypoint-initdb.d
    environment:
      MYSQL_ROOT_PASSWORD: rootpassword
      MYSQL_USER: wpuser
      MYSQL_PASSWORD: wppassword
    restart: unless-stopped

$(for i in {1..4}; do
  port=$((8090 + i - 1))
  ip=$((10 + i - 1))
  cat <<WPEOF
  wordpress${i}:
    image: wordpress:php8.1-apache
    container_name: wp_site${i}
    networks:
      wp_network:
        ipv4_address: 10.110.112.${ip}
    ports:
      - "${port}:80"
    volumes:
      - ./wp${i}:/var/www/html
      - ./php-inis/php${i}.ini:/usr/local/etc/php/conf.d/custom-php.ini
      - ./envs/wp${i}.env:/var/www/html/.env
    environment:
      WORDPRESS_DB_HOST: db
      WORDPRESS_DB_USER: wpuser
      WORDPRESS_DB_PASSWORD: wppassword
      WORDPRESS_DB_NAME: wordpress${i}
    depends_on:
      - db
    restart: unless-stopped

WPEOF
done)

networks:
  wp_network:
    driver: bridge
    ipam:
      config:
        - subnet: 10.110.112.0/24

volumes:
  db_data:
EOF

echo "Скриптът завърши успешно!"
echo "Стартирайте с: docker compose up -d"
echo "Сайтовете ще са достъпни на:"
echo "http://<ваш-ip>:8090 до http://<ваш-ip>:8093"
echo "Може да ви е интересно да видите още скриптове на:"
echo "https://urocibg.eu/category/scripts/"