#!/bin/bash

# Автор: Федя Серафиев (модифициран за стабилни версии)

# ====== ВХОДНИ ДАННИ ОТ ПОТРЕБИТЕЛЯ ======
read -p "👉 Въведи име за сайта (използва се за име на контейнерите, volumes и мрежа): " SITE_NAME
SITE_NAME=$(echo "$SITE_NAME" | tr -d ' ')

read -p "👉 Въведи външен порт за достъп до WordPress (напр. 8080): " HOST_PORT
HOST_PORT=${HOST_PORT:-8080}

# ====== ПАРОЛИ И ПАРАМЕТРИ ======
MYSQL_ROOT_PASSWORD=$(openssl rand -base64 16)
MYSQL_DATABASE="wordpress"
MYSQL_USER="wpuser"
MYSQL_PASSWORD=$(openssl rand -base64 16)

# ====== СТРУКТУРА НА ПАПКИТЕ ======
mkdir -p "$SITE_NAME"/{config,wordpress,db_data}
cd "$SITE_NAME"

# ====== .env ФАЙЛ ======
cat > .env <<EOF
MYSQL_ROOT_PASSWORD=${MYSQL_ROOT_PASSWORD}
MYSQL_DATABASE=${MYSQL_DATABASE}
MYSQL_USER=${MYSQL_USER}
MYSQL_PASSWORD=${MYSQL_PASSWORD}
WORDPRESS_DB_HOST=${SITE_NAME}_db:3306
EOF

# ====== config/php.ini ======
cat > config/php.ini <<EOF
upload_max_filesize = 64M
post_max_size = 64M
memory_limit = 256M
EOF

# ====== docker-compose.yml ======
cat > docker-compose.yml <<EOF
version: '3.8'

services:
  ${SITE_NAME}_db:
    image: mysql:5.7
    container_name: ${SITE_NAME}_db
    restart: always
    volumes:
      - ./db_data:/var/lib/mysql
    environment:
      MYSQL_ROOT_PASSWORD: \${MYSQL_ROOT_PASSWORD}
      MYSQL_DATABASE: \${MYSQL_DATABASE}
      MYSQL_USER: \${MYSQL_USER}
      MYSQL_PASSWORD: \${MYSQL_PASSWORD}
    networks:
      - ${SITE_NAME}_net

  ${SITE_NAME}_wp:
    image: wordpress:6.4-php8.1-apache
    container_name: ${SITE_NAME}_wp
    depends_on:
      - ${SITE_NAME}_db
    ports:
      - "${HOST_PORT}:80"
    restart: always
    volumes:
      - ./wordpress:/var/www/html
      - ./config/php.ini:/usr/local/etc/php/conf.d/custom.ini
    environment:
      WORDPRESS_DB_HOST: \${WORDPRESS_DB_HOST}
      WORDPRESS_DB_NAME: \${MYSQL_DATABASE}
      WORDPRESS_DB_USER: \${MYSQL_USER}
      WORDPRESS_DB_PASSWORD: \${MYSQL_PASSWORD}
    networks:
      - ${SITE_NAME}_net

networks:
  ${SITE_NAME}_net:
    driver: bridge
EOF

# ====== ИНФОРМАЦИЯ ======
echo
echo "✅ WordPress инстанция \"$SITE_NAME\" е готова."
echo "📁 Файловете на сайта са в: $(pwd)/wordpress"
echo "🌐 Достъп: http://localhost:${HOST_PORT}"
echo "🔐 Данни за база данни (в .env):"
echo "MYSQL_USER=${MYSQL_USER}"
echo "MYSQL_PASSWORD=${MYSQL_PASSWORD}"
echo "MYSQL_ROOT_PASSWORD=${MYSQL_ROOT_PASSWORD}"
echo ""
echo "🚀 Стартирай сайта със: docker compose up -d"