#!/bin/bash

# Proxmox VE Post-Install Configuration Script
# Автор: Федя Серафиев и Proxmox Helper Scripts
# Версия: 1.0

# Цветови променливи
RD=$(echo "\033[01;31m")
YW=$(echo "\033[33m")
GN=$(echo "\033[1;92m")
BL=$(echo "\033[36m")
CL=$(echo "\033[m")
BFR="\\r\\033[K"
HOLD="-"
CM="${GN}✓${CL}"
CROSS="${RD}✗${CL}"

# Функции за съобщения
msg_info() {
    local msg="$1"
    echo -ne " ${HOLD} ${YW}${msg}..."
}

msg_ok() {
    local msg="$1"
    echo -e "${BFR} ${CM} ${GN}${msg}${CL}"
}

msg_error() {
    local msg="$1"
    echo -e "${BFR} ${CROSS} ${RD}${msg}${CL}"
}

# Хедър информация
header_info() {
    clear
    cat <<"EOF"
    ____                                     _    ____________
   / __ \_________  _  ______ ___  ____  | |  / / ____/    
  / /_/ / ___/ __ \| |/_/ __ `__ \/ __ \ | | / / __/   
 / ____/ /  / /_/ />  </ / / / / / /_/ / | |/ / /___   
/_/   /_/   \____/_/|_/_/ /_/ /_/\____/  |___/_____/   
                                                        
    ____             __     ____           __        ____
   / __ \____  _____/ /_   /  _/___  _____/ /_____ _/ / /
  / /_/ / __ \/ ___/ __/   / // __ \/ ___/ __/ __ `/ / /
 / ____/ /_/ (__  ) /_   _/ // / / (__  ) /_/ /_/ / / / 
/_/    \____/____/\__/  /___/_/ /_/____/\__/\__,_/_/_/  
                                                        
           Конфигурационен скрипт за Proxmox VE
                    Версия 1.0
EOF
    echo -e "${BL}════════════════════════════════════════════════════════════${CL}"
    echo -e "${GN}Добре дошли в помощника за конфигуриране на Proxmox VE!${CL}"
    echo -e "${BL}════════════════════════════════════════════════════════════${CL}"
    echo
}

# Проверка за root права
check_root() {
    if [[ $EUID -ne 0 ]]; then
        msg_error "Този скрипт трябва да бъде стартиран като root потребител"
        exit 1
    fi
}

# Проверка за Proxmox VE
check_proxmox() {
    if [[ ! -f /etc/pve/local/pve-ssl.pem ]]; then
        msg_error "Proxmox VE не е открит в тази система"
        exit 1
    fi
}

# Функция за изключване на напомнянето за абонамент
disable_subscription_nag() {
    if [[ ! -f /etc/apt/apt.conf.d/no-nag-script ]]; then
        CHOICE=$(whiptail --backtitle "Proxmox VE Helper Scripts" --title "НАПОМНЯНЕ ЗА АБОНАМЕНТ" --menu "Това ще изключи съобщението, което ви напомня да закупите абонамент всеки път, когато влезете в уеб интерфейса.\n \nИзключване на напомнянето за абонамент?" 14 58 2 \
          "yes" " " \
          "no" " " 3>&2 2>&1 1>&3)
        case $CHOICE in
        yes)
            whiptail --backtitle "Proxmox VE Helper Scripts" --msgbox --title "Поддръжка на абонаменти" "Подкрепата на екипа за разработка на софтуера е от съществено значение. Проверете официалния уебсайт за Поддръжка на абонаменти за цени. Без тяхната посветена работа нямаше да имаме този изключителен софтуер." 10 58
            msg_info "Изключване на напомнянето за абонамент"
            echo "DPkg::Post-Invoke { \"dpkg -V proxmox-widget-toolkit | grep -q '/proxmoxlib\.js$'; if [ \$? -eq 1 ]; then { echo 'Премахване на напомнянето от интерфейса...'; sed -i '/.*data\.status.*{/{s/\!//;s/active/NoMoreNagging/}' /usr/share/javascript/proxmox-widget-toolkit/proxmoxlib.js; }; fi\"; };" >/etc/apt/apt.conf.d/no-nag-script
            apt --reinstall install proxmox-widget-toolkit &>/dev/null
            msg_ok "Напомнянето за абонамент е изключено (Изтрийте кеша на браузъра)"
            ;;
        no)
            msg_error "Избрахте 'не' за изключване на напомнянето"
            ;;
        esac
    else
        msg_ok "Напомнянето за абонамент вече е изключено"
    fi
}

# Функция за корекция на източниците
fix_sources() {
    CHOICE=$(whiptail --backtitle "Proxmox VE Helper Scripts" --title "КОРЕКЦИЯ НА ИЗТОЧНИЦИТЕ" --menu "Това ще коригира източниците на Proxmox VE за правилна работа.\n \nКорекция на източниците на Proxmox VE?" 14 58 2 \
      "yes" " " \
      "no" " " 3>&2 2>&1 1>&3)
    case $CHOICE in
    yes)
        msg_info "Коригиране на източниците на Proxmox VE"
        cat <<EOF >/etc/apt/sources.list
deb http://deb.debian.org/debian bookworm main contrib
deb http://deb.debian.org/debian bookworm-updates main contrib
deb http://security.debian.org/debian-security bookworm-security main contrib
EOF
        echo 'APT::Get::Update::SourceListWarnings::NonFreeFirmware "false";' >/etc/apt/apt.conf.d/no-bookworm-firmware.conf
        msg_ok "Източниците на Proxmox VE са коригирани"
        ;;
    no)
        msg_error "Избрахте 'не' за корекция на източниците"
        ;;
    esac
}

# Функция за изключване на enterprise хранилище
disable_enterprise_repo() {
    CHOICE=$(whiptail --backtitle "Proxmox VE Helper Scripts" --title "PVE-ENTERPRISE" --menu "Хранилището 'pve-enterprise' е достъпно само за потребители, закупили абонамент за Proxmox VE.\n \nИзключване на 'pve-enterprise' хранилище?" 14 58 2 \
      "yes" " " \
      "no" " " 3>&2 2>&1 1>&3)
    case $CHOICE in
    yes)
        msg_info "Изключване на 'pve-enterprise' хранилище"
        cat <<EOF >/etc/apt/sources.list.d/pve-enterprise.list
# deb https://enterprise.proxmox.com/debian/pve bookworm pve-enterprise
EOF
        msg_ok "'pve-enterprise' хранилището е изключено"
        ;;
    no)
        msg_error "Избрахте 'не' за изключване на хранилището"
        ;;
    esac
}

# Функция за активиране на no-subscription хранилище
enable_no_subscription_repo() {
    CHOICE=$(whiptail --backtitle "Proxmox VE Helper Scripts" --title "PVE-NO-SUBSCRIPTION" --menu "Хранилището 'pve-no-subscription' предоставя достъп до всички компоненти с отворен код на Proxmox VE.\n \nАктивиране на 'pve-no-subscription' хранилище?" 14 58 2 \
      "yes" " " \
      "no" " " 3>&2 2>&1 1>&3)
    case $CHOICE in
    yes)
        msg_info "Активиране на 'pve-no-subscription' хранилище"
        cat <<EOF >/etc/apt/sources.list.d/pve-install-repo.list
deb http://download.proxmox.com/debian/pve bookworm pve-no-subscription
EOF
        msg_ok "'pve-no-subscription' хранилището е активирано"
        ;;
    no)
        msg_error "Избрахте 'не' за активиране на хранилището"
        ;;
    esac
}

# Функция за обновяване на системата
update_system() {
    CHOICE=$(whiptail --backtitle "Proxmox VE Helper Scripts" --title "ОБНОВЯВАНЕ НА СИСТЕМАТА" --menu "Това ще обнови всички пакети в системата.\n \nОбновяване на системата?" 14 58 2 \
      "yes" " " \
      "no" " " 3>&2 2>&1 1>&3)
    case $CHOICE in
    yes)
        msg_info "Обновяване на списъка с пакети"
        apt update &>/dev/null
        msg_ok "Списъкът с пакети е обновен"
        
        msg_info "Обновяване на системата"
        apt full-upgrade -y &>/dev/null
        msg_ok "Системата е обновена"
        
        msg_info "Почистване на ненужни пакети"
        apt autoremove -y &>/dev/null
        apt autoclean &>/dev/null
        msg_ok "Ненужните пакети са премахнати"
        ;;
    no)
        msg_error "Избрахте 'не' за обновяване на системата"
        ;;
    esac
}

# Функция за конфигуриране на firewall
configure_firewall() {
    CHOICE=$(whiptail --backtitle "Proxmox VE Helper Scripts" --title "FIREWALL КОНФИГУРАЦИЯ" --menu "Активиране на основна firewall конфигурация?\n \nТова ще активира основни firewall правила за защита." 14 58 2 \
      "yes" " " \
      "no" " " 3>&2 2>&1 1>&3)
    case $CHOICE in
    yes)
        msg_info "Конфигуриране на firewall"
        # Активиране на firewall в Proxmox
        pvesh set /cluster/firewall/options --enable 1 &>/dev/null
        msg_ok "Firewall е активиран"
        ;;
    no)
        msg_error "Избрахте 'не' за активиране на firewall"
        ;;
    esac
}

# Функция за показване на системна информация
show_system_info() {
    clear
    header_info
    echo -e "${BL}════════════════════════════════════════════════════════════${CL}"
    echo -e "${GN}                    СИСТЕМНА ИНФОРМАЦИЯ                     ${CL}"
    echo -e "${BL}════════════════════════════════════════════════════════════${CL}"
    echo
    echo -e "${YW}Proxmox VE версия:${CL} $(pveversion | head -1)"
    echo -e "${YW}Операционна система:${CL} $(lsb_release -d | cut -f2)"
    echo -e "${YW}Kernel версия:${CL} $(uname -r)"
    echo -e "${YW}Архитектура:${CL} $(uname -m)"
    echo -e "${YW}Възходящо време:${CL} $(uptime -p)"
    echo -e "${YW}Натоварване:${CL} $(uptime | awk -F'load average:' '{print $2}')"
    echo -e "${YW}Памет:${CL} $(free -h | grep '^Mem:' | awk '{print $3"/"$2}')"
    echo -e "${YW}Дисково пространство:${CL} $(df -h / | tail -1 | awk '{print $3"/"$2" ("$5" използвано)"}')"
    echo
    echo -e "${BL}════════════════════════════════════════════════════════════${CL}"
    echo
    read -p "Натиснете Enter за връщане в главното меню..."
}

# Главно меню
main_menu() {
    while true; do
        header_info
        CHOICE=$(whiptail --backtitle "Proxmox VE Helper Scripts" --title "ГЛАВНО МЕНЮ" --menu "Изберете опция:" 20 70 10 \
          "1" "Изключване на напомнянето за абонамент" \
          "2" "Корекция на източниците" \
          "3" "Изключване на enterprise хранилище" \
          "4" "Активиране на no-subscription хранилище" \
          "5" "Обновяване на системата" \
          "6" "Конфигуриране на firewall" \
          "7" "Показване на системна информация" \
          "8" "Изпълнение на всички конфигурации" \
          "9" "Изход" 3>&2 2>&1 1>&3)
        
        case $CHOICE in
        1)
            disable_subscription_nag
            ;;
        2)
            fix_sources
            ;;
        3)
            disable_enterprise_repo
            ;;
        4)
            enable_no_subscription_repo
            ;;
        5)
            update_system
            ;;
        6)
            configure_firewall
            ;;
        7)
            show_system_info
            ;;
        8)
            echo -e "${GN}Изпълнение на всички конфигурации...${CL}"
            echo
            disable_subscription_nag
            fix_sources
            disable_enterprise_repo
            enable_no_subscription_repo
            update_system
            configure_firewall
            echo
            echo -e "${GN}Всички конфигурации са завършени!${CL}"
            echo -e "${YW}Препоръчва се рестартиране на системата.${CL}"
            echo
            read -p "Натиснете Enter за връщане в главното меню..."
            ;;
        9)
            echo -e "${GN}Благодарим ви за използването на Proxmox VE Helper Scripts!${CL}"
            exit 0
            ;;
        *)
            msg_error "Невалидна опция"
            ;;
        esac
        
        echo
        read -p "Натиснете Enter за връщане в главното меню..."
    done
}

# Основна функция
main() {
    check_root
    check_proxmox
    
    # Проверка за whiptail
    if ! command -v whiptail &> /dev/null; then
        msg_info "Инсталиране на whiptail"
        apt update &>/dev/null
        apt install -y whiptail &>/dev/null
        msg_ok "whiptail е инсталиран"
    fi
    
    main_menu
}

# Стартиране на скрипта
main "$@"