#!/bin/bash

# Цветове
GREEN='\033[0;32m'
YELLOW='\033[1;33m'
RED='\033[0;31m'
NC='\033[0m'

echo -e "${GREEN}================================${NC}"
echo -e "${GREEN}Node Exporter Quick Install${NC}"
echo -e "${GREEN}За Proxmox LXC контейнери${NC}"
echo -e "${GREEN}================================${NC}\n"

# Проверка за root
if [[ $EUID -ne 0 ]]; then
   echo -e "${RED}Този скрипт трябва да се изпълни като root!${NC}"
   exit 1
fi

# Актуализация
echo -e "${YELLOW}[1/4] Актуализация на системата...${NC}"
apt-get update -qq > /dev/null 2>&1
apt-get install -y wget tar > /dev/null 2>&1

# Създаване на потребител
echo -e "${YELLOW}[2/4] Създаване на node_exporter потребител...${NC}"
useradd --no-create-home --shell /bin/false node_exporter 2>/dev/null || true

# Инсталация на Node Exporter
echo -e "${YELLOW}[3/4] Инсталация на Node Exporter...${NC}"
NODE_VERSION="1.6.1"
wget -q https://github.com/prometheus/node_exporter/releases/download/v${NODE_VERSION}/node_exporter-${NODE_VERSION}.linux-amd64.tar.gz

if [ $? -ne 0 ]; then
    echo -e "${RED}Грешка при изтеглянето на Node Exporter!${NC}"
    exit 1
fi

tar xzf node_exporter-${NODE_VERSION}.linux-amd64.tar.gz
cp node_exporter-${NODE_VERSION}.linux-amd64/node_exporter /usr/local/bin/
chown node_exporter:node_exporter /usr/local/bin/node_exporter
rm -rf node_exporter-${NODE_VERSION}.linux-amd64*

# Systemd service
cat > /etc/systemd/system/node_exporter.service <<EOF
[Unit]
Description=Node Exporter
Wants=network-online.target
After=network-online.target

[Service]
User=node_exporter
Group=node_exporter
Type=simple
ExecStart=/usr/local/bin/node_exporter

[Install]
WantedBy=multi-user.target
EOF

# Стартиране
echo -e "${YELLOW}[4/4] Стартиране на Node Exporter...${NC}"
systemctl daemon-reload
systemctl enable node_exporter > /dev/null 2>&1
systemctl start node_exporter

# Проверка
sleep 2
if systemctl is-active --quiet node_exporter; then
    echo -e "\n${GREEN}✓ Node Exporter е инсталиран успешно!${NC}"
    
    CONTAINER_IP=$(hostname -I | awk '{print $1}')
    CONTAINER_NAME=$(hostname)
    
    echo -e "\n${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
    echo -e "${GREEN}Информация за контейнера:${NC}"
    echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
    echo -e "   Hostname:     ${GREEN}${CONTAINER_NAME}${NC}"
    echo -e "   IP Address:   ${GREEN}${CONTAINER_IP}${NC}"
    echo -e "   Port:         ${GREEN}9100${NC}"
    echo -e "   Metrics URL:  ${GREEN}http://${CONTAINER_IP}:9100/metrics${NC}"
    
    echo -e "\n${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
    echo -e "${GREEN}Следващи стъпки:${NC}"
    echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}"
    echo -e "1. Отвори SSH към ${GREEN}мониторинг контейнера${NC}"
    echo -e "2. Изпълни:\n"
    echo -e "   ${GREEN}add-lxc-container ${CONTAINER_IP} '${CONTAINER_NAME}'${NC}\n"
    echo -e "   или ръчно редактирай: ${GREEN}/etc/prometheus/prometheus.yml${NC}"
    echo -e "   и добави:"
    echo -e "   ${YELLOW}  - targets: ['${CONTAINER_IP}:9100']${NC}"
    echo -e "   ${YELLOW}    labels:${NC}"
    echo -e "   ${YELLOW}      alias: '${CONTAINER_NAME}'${NC}"
    echo -e "   ${YELLOW}      type: 'lxc-container'${NC}\n"
    echo -e "3. Рестартирай Prometheus: ${GREEN}systemctl restart prometheus${NC}"
    echo -e "${YELLOW}━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━${NC}\n"
    
    exit 0
else
    echo -e "\n${RED}✗ Node Exporter не успя да стартира!${NC}"
    echo -e "${YELLOW}Провери логовете: journalctl -u node_exporter -f${NC}\n"
    exit 1
fi